// -*-C++-*-
//      unixtimer.cxx:
//              UnixTimer Object Implementation using gettimeofday(2)
//              
//      12 Jun 1998  Seiji Tada, HSTD MST R&D, HP Japan
//
#include <unistd.h>
#include "unixtimer.h"
//extern "C" VOID GetDevPath(char *path_p);

UnixTimer::UnixTimer ()
:mIsStopped(MSTTrue)
{
    mStartTime.tv_sec = 0;
    mStartTime.tv_usec = 0;
    mStopTime.tv_sec = 0;
    mStopTime.tv_usec = 0;
}

UnixTimer::UnixTimer (const UnixTimer & aTimer)
{
    mStartTime = aTimer.mStartTime;
    mStopTime = aTimer.mStopTime;
    mIsStopped = aTimer.mIsStopped;
}

UnixTimer & UnixTimer::operator= (const UnixTimer & aTimer)
{
    if (this == &aTimer) {
        return *this;
    }
    mStartTime = aTimer.mStartTime;
    mStopTime = aTimer.mStopTime;
    mIsStopped = aTimer.mIsStopped;
    return *this;
}

UnixTimer::~UnixTimer()
{
}

void UnixTimer::start()
{
    if (mIsStopped) {
        gettimeofday(&mStartTime, NULL);
        mIsStopped = MSTFalse;
    }
}

void UnixTimer::stop()
{
    if (!mIsStopped) {
        gettimeofday(&mStopTime, NULL);
        mIsStopped = MSTTrue;
    }
}

void UnixTimer::reset()
{
    mStartTime.tv_sec = 0;
    mStartTime.tv_usec = 0;
    mStopTime.tv_sec = 0;
    mStopTime.tv_usec = 0;
    mIsStopped = MSTTrue;
}

double UnixTimer::read()
{
    double dTime;
    struct timeval current;
    
    if (mIsStopped)
        current = mStopTime;
    else
        gettimeofday(&current, NULL);

    if (mStartTime.tv_usec > current.tv_usec) {
        current.tv_usec += 1000000;
        current.tv_sec--;
    }

    dTime = (double) ((current.tv_sec - mStartTime.tv_sec) * 1000000 +
                     (current.tv_usec - mStartTime.tv_usec));

    dTime=dTime*1.0e-6;

    return (double) dTime;
}



UnixTimer aTimer;

